// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_chrono_module_apple.h
 *  \brief      MGL macOS用の日付と時間のモジュール
 *  \date       Since: February 24, 2021. 5:35:32 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_CHRONO_MODULE_APPLE_H_1614112532
#define INCGUARD_MGL_CHRONO_MODULE_APPLE_H_1614112532

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)

#include <mgl/system/chrono/mgl_chrono_module_interface.h>

namespace MGL::System
{
//! macOS用の日付と時間のモジュール
class AppleChronoModule : public ChronoModuleInterface
{
public:
    AppleChronoModule() noexcept;

    [[nodiscard]] EpochTime GetCurrentEpochTime() const noexcept override;

    [[nodiscard]] bool IsAvailableTickTimer() const noexcept override;
    [[nodiscard]] TickTime GetTickTime() const noexcept override;
    [[nodiscard]] float TicksToNanoseconds(TickTime tickTime) const noexcept override;
};
}    // namespace MGL::System

#endif    // defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)
#endif    // INCGUARD_MGL_CHRONO_MODULE_APPLE_H_1614112532

// vim: et ts=4 sw=4 sts=4
