// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_chrono_elapsed_timer.h
 *  \brief      MGL 経過タイマー
 *  \date       Since: February 24, 2021. 6:27:40 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_CHRONO_ELAPSED_TIMER_H_1614115660
#define INCGUARD_MGL_CHRONO_ELAPSED_TIMER_H_1614115660

#include <mgl/system/mgl_system_chrono.h>

namespace MGL::System
{
//! 経過タイマークラス
class ElapsedTimer
{
public:
    ElapsedTimer() noexcept;
    ElapsedTimer(TickTime tickTime) noexcept;

    void Lap() noexcept;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      測定された時間をミリ秒で取得
     *  \return     測定された時間（ミリ秒）
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr float GetLappedTimeMillisecond() const noexcept
    {
        return _lappedTimeNanosecond / 1000.0f / 1000.0f;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      測定された時間をマイクロ秒で取得
     *  \return     測定された時間（マイクロ秒）
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr float GetLappedTimeMicrosecond() const noexcept
    {
        return _lappedTimeNanosecond / 1000.0f;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      測定された時間をナノ秒で取得
     *  \return     測定された時間（ナノ秒）
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr float GetLappedTimeNanosecond() const noexcept
    {
        return _lappedTimeNanosecond;
    }

private:
    TickTime _tick;
    float _lappedTimeNanosecond;
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_CHRONO_ELAPSED_TIMER_H_1614115660

// vim: et ts=4 sw=4 sts=4
