// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_application_module_win32.h
 *  \brief      MGL Win32用アプリケーションモジュール
 *  \date       Since: March 29, 2021. 16:31:09 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_APPLICATION_MODULE_WIN32_H_1617003069
#define INCGUARD_MGL_APPLICATION_MODULE_WIN32_H_1617003069

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_WIN32)

#include <mgl/system/application/mgl_application_module_common.h>

namespace MGL::System
{
//! Win32用アプリケーションモジュール
class Win32ApplicationModule : public CommonApplicationModule
{
public:
    Win32ApplicationModule() noexcept;

    bool Caffeinate(bool isEnabled) noexcept override;
    [[nodiscard]] bool IsCaffeinated() const noexcept override;

    [[nodiscard]] const ArgumentArray &GetArguments() const noexcept override;

    void Quit() noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      アプリケーションの終了をサポートしているかを取得
     *  \retval     true    サポートしている
     *  \retval     false   サポートしていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailableQuit() const noexcept override
    {
        return true;
    }

    bool SetClipboardText(const char *text) noexcept override;
    [[nodiscard]] bool GetClipboardText(STL::string &text) noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      システムがクリップボードをサポートしているかを取得
     *  \retval     true    サポートしている
     *  \retval     false   サポートしていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailableClipboard() const noexcept override
    {
        return true;
    }

private:
    ArgumentArray _argumentArray;
    bool _isCaffeinated;
};
}    // namespace MGL::System

#endif    // MGL_TARGET_WIN32
#endif    // INCGUARD_MGL_APPLICATION_MODULE_WIN32_H_1617003069

// vim: et ts=4 sw=4 sts=4
