// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_application_module_uikit.h
 *  \brief      MGL iOS/tvOS用アプリケーションモジュール
 *  \date       Since: February 25, 2021. 10:42:55 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_APPLICATION_MODULE_UIKIT_H_1614217375
#define INCGUARD_MGL_APPLICATION_MODULE_UIKIT_H_1614217375

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)

#include <mgl/system/application/mgl_application_module_common.h>

namespace MGL::System
{
//! iOS/tvOS用アプリケーションモジュール
class UIKitApplicationModule : public CommonApplicationModule
{
public:
    UIKitApplicationModule() noexcept;
    
    bool Caffeinate(bool isEnabled) noexcept override;
    [[nodiscard]] bool IsCaffeinated() const noexcept override;

    [[nodiscard]] const ArgumentArray &GetArguments() const noexcept override;

    void Quit() noexcept override;
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      アプリケーションの終了をサポートしているかを取得
     *  \retval     true    サポートしている
     *  \retval     false   サポートしていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailableQuit() const noexcept override
    {
        return false;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      クリップボードにテキストをコピー
     *  \param[in]  text    コピーするテキスト
     *  \retval     true    成功
     *  \retval     false   失敗
     */
    /* ------------------------------------------------------------------------- */
    bool SetClipboardText([[maybe_unused]] const char *text) noexcept override
    {
        return false;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      クリップボードからテキストを取得
     *  \param[out] text    テキストのコピー先
     *  \retval     true    成功
     *  \retval     false   失敗
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool GetClipboardText([[maybe_unused]] STL::string &text) noexcept override
    {
        return false;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      システムがクリップボードをサポートしているかを取得
     *  \retval     true    サポートしている
     *  \retval     false   サポートしていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailableClipboard() const noexcept override
    {
        return false;
    }
    
private:
    ArgumentArray _argumentArray;
};
}   // namespace MGL::System

#endif  // defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)
#endif	// INCGUARD_MGL_APPLICATION_MODULE_UIKIT_H_1614217375

// vim: et ts=4 sw=4 sts=4
