// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_application_module_macos.h
 *  \brief      MGL macOS用アプリケーションモジュール
 *  \date       Since: February 22, 2021. 10:47:58 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_APPLICATION_MODULE_MACOS_H_1613958478
#define INCGUARD_MGL_APPLICATION_MODULE_MACOS_H_1613958478

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_MACOS)

#include <IOKit/pwr_mgt/IOPMLib.h>

#include <mgl/system/application/mgl_application_module_common.h>

namespace MGL::System
{
//! macOS用アプリケーションモジュール
class MacOSApplicationModule : public CommonApplicationModule
{
public:
    MacOSApplicationModule() noexcept;

    bool Caffeinate(bool isEnabled) noexcept override;
    [[nodiscard]] bool IsCaffeinated() const noexcept override;

    const ArgumentArray &GetArguments() const noexcept override;

    void Quit() noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      アプリケーションの終了をサポートしているかを取得
     *  \retval     true    サポートしている
     *  \retval     false   サポートしていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailableQuit() const noexcept override
    {
        return true;
    }

    bool SetClipboardText(const char *text) noexcept override;
    [[nodiscard]] bool GetClipboardText(STL::string &text) noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      システムがクリップボードをサポートしているかを取得
     *  \retval     true    サポートしている
     *  \retval     false   サポートしていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailableClipboard() const noexcept override
    {
        return true;
    }

private:
    ArgumentArray _argumentArray;
    IOPMAssertionID _caffeinateAssertionID;
};
}    // namespace MGL::System

#endif    // MGL_TARGET_MACOS
#endif    // INCGUARD_MGL_APPLICATION_MODULE_MACOS_H_1613958478

// vim: et ts=4 sw=4 sts=4
