// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_application_module_default.h
 *  \brief      MGL デフォルトのアプリケーションモジュール
 *  \date       Since: February 22, 2021. 12:04:09 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_APPLICATION_MODULE_DEFAULT_H_1613963049
#define INCGUARD_MGL_APPLICATION_MODULE_DEFAULT_H_1613963049

#include <mgl/system/application/mgl_application_module_common.h>

namespace MGL::System
{
//! デフォルトのアプリケーションモジュール
class DefaultApplicationModule : public CommonApplicationModule
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     */
    /* ------------------------------------------------------------------------- */
    DefaultApplicationModule() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      スリープの抑制
     *  \param[in]  isEnabled   有効フラグ
     *  \retval     true        成功
     *  \retval     false       失敗
     */
    /* ------------------------------------------------------------------------- */
    bool Caffeinate([[maybe_unused]] bool isEnabled) noexcept override
    {
        return false;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      スリープの抑制状態を取得
     *  \retval     true    有効
     *  \retval     false   無効
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsCaffeinated() const noexcept override
    {
        return false;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      実行引数を取得
     *  \return     実行引数の配列
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] const ArgumentArray &GetArguments() const noexcept override
    {
        return _argumentArray;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      アプリケーションの終了
     */
    /* ------------------------------------------------------------------------- */
    void Quit() noexcept override
    {
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      アプリケーションの終了をサポートしているかを取得
     *  \retval     true    サポートしている
     *  \retval     false   サポートしていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailableQuit() const noexcept override
    {
        return false;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      クリップボードにテキストをコピー
     *  \param[in]  text    コピーするテキスト
     *  \retval     true    成功
     *  \retval     false   失敗
     */
    /* ------------------------------------------------------------------------- */
    bool SetClipboardText([[maybe_unused]] const char *text) noexcept override
    {
        return false;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      クリップボードからテキストを取得
     *  \param[out] text    テキストのコピー先
     *  \retval     true    成功
     *  \retval     false   失敗
     */
    /* ------------------------------------------------------------------------- */
    bool GetClipboardText([[maybe_unused]] STL::string &text) noexcept override
    {
        return false;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      システムがクリップボードをサポートしているかを取得
     *  \retval     true    サポートしている
     *  \retval     false   サポートしていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailableClipboard() const noexcept override
    {
        return false;
    }

private:
    ArgumentArray _argumentArray;
};
}    // namespace MGL::System

#endif    // INCGUARD_MGL_APPLICATION_MODULE_DEFAULT_H_1613963049

// vim: et ts=4 sw=4 sts=4
