// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_application_module_common.h
 *  \brief      MGL 共通アプリケーションモジュール
 *  \date       Since: February 22, 2021. 11:54:18 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_APPLICATION_MODULE_COMMON_H_1613962458
#define INCGUARD_MGL_APPLICATION_MODULE_COMMON_H_1613962458

#include <mgl/system/application/mgl_application_module_interface.h>

#include <mgl/event/mgl_event.h>
#include <mgl/system/chrono/mgl_chrono_elapsed_timer.h>

namespace MGL::System
{
//! 共通アプリケーションモジュール
class CommonApplicationModule : public ApplicationModuleInterface
{
public:
    CommonApplicationModule() noexcept;
    ~CommonApplicationModule() noexcept override = default;

    [[nodiscard]] float GetFrameElapsedTime() const noexcept override;
    [[nodiscard]] uint32_t GetFramesPerSecond() const noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      アプリケーションデリゲートの登録
     *  \param[in]  delegate    登録するアプリケーションデリゲート
     */
    /* ------------------------------------------------------------------------- */
    void SetApplicationDelegate(STL::unique_ptr<ApplicationDelegate> delegate) noexcept override
    {
        _delegate = std::move(delegate);
    }

private:
    static void OnEventPreFrameUpdate(void *callbackArg, void *notifyArg) noexcept;

    void UpdateFPS() noexcept;

    Event::Handle _eventPreFrameUpdate;
    ElapsedTimer _elapsedTimer{0};
    EpochTime _prevUpdateTime{0};
    uint32_t _frameUpdateCount{0};
    uint32_t _fps{0};
    STL::unique_ptr<ApplicationDelegate> _delegate;
};

}    // namespace MGL::System

#endif    // INCGUARD_MGL_APPLICATION_MODULE_COMMON_H_1613962458

// vim: et ts=4 sw=4 sts=4
