// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_stl_string.h
 *  \brief      MGL STL文字列クラスの代替
 *  \date       Since: May 2, 2022. 2:59:48 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_STL_STRING_H_1651427988
#define INCGUARD_MGL_STL_STRING_H_1651427988

#include <string>

#include <mgl/stl/mgl_stl_memory.h>

namespace MGL::STL
{
//! std::basic_stringの代替
template <class charT, class traits = std::char_traits<charT>>
using basic_string = std::basic_string<charT, traits, Allocator<charT>>;

//! std::stringの代替
using string = basic_string<char>;

//! std::u16stringの代替
using u16string = basic_string<char16_t>;

//! std::u32stringの代替
using u32string = basic_string<char32_t>;

//! std::wstringの代替
using wstring = basic_string<wchar_t>;

}    // namespace MGL::STL

#endif    // INCGUARD_MGL_STL_STRING_H_1651427988

// vim: et ts=4 sw=4 sts=4
