/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_stl_hash.h
 *  \brief      MGL STL用ハッシュクラス
 *  \date       Since: December 16, 2024. 0:28:58 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_STL_HASH_H_1734276538
#define INCGUARD_MGL_STL_HASH_H_1734276538

#include <functional>
#include <string_view>

namespace MGL::STL::Hash
{
//! MGL::STL::string用ハッシュクラス
struct string
{
    size_t operator()(std::string_view view) const
    {
        return std::hash<std::string_view>{}(view);
    }
};

//! MGL::STL::u16string用ハッシュクラス
struct u16string
{
    size_t operator()(std::u16string_view view) const
    {
        return std::hash<std::u16string_view>{}(view);
    }
};

//! MGL::STL::u32string用ハッシュクラス
struct u32string
{
    size_t operator()(std::u32string_view view) const
    {
        return std::hash<std::u32string_view>{}(view);
    }
};

//! MGL::STL::wstring用ハッシュクラス
struct wstring
{
    size_t operator()(std::wstring_view view) const
    {
        return std::hash<std::wstring_view>{}(view);
    }
};
}    // namespace MGL::STL::Hash

#endif    // INCGUARD_MGL_STL_HASH_H_1734276538

// vim: et ts=4 sw=4 sts=4
