// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_stl_containers.h
 *  \brief      MGL STLコンテナの代替
 *  \date       Since: April 29, 2022. 23:27:49 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_STL_CONTAINERS_H_1651242469
#define INCGUARD_MGL_STL_CONTAINERS_H_1651242469

#include <deque>
#include <stack>
#include <queue>
#include <vector>
#include <forward_list>
#include <list>
#include <map>
#include <set>
#include <unordered_map>
#include <unordered_set>

#include <mgl/stl/mgl_stl_memory.h>

namespace MGL::STL
{
//! std::dequeの代替
template <class T>
using deque = std::deque<T, Allocator<T>>;

//! std::stackの代替
template <class T>
using stack = std::stack<T, deque<T>>;

//! std::queueの代替
template <class T>
using queue = std::queue<T, deque<T>>;

//! std::forward_listの代替
template <class T>
using forward_list = std::forward_list<T, Allocator<T>>;

//! std::listの代替
template <class T>
using list = std::list<T, Allocator<T>>;

//! std::vectorの代替
template <class T>
using vector = std::vector<T, Allocator<T>>;

//! std::mapの代替
template <class Key, class T, class Compare = std::less<Key>>
using map = std::map<Key, T, Compare, Allocator<std::pair<const Key, T>>>;

//! std::multimapの代替
template <class Key, class T, class Compare = std::less<Key>>
using multimap = std::multimap<Key, T, Compare, Allocator<std::pair<const Key, T>>>;

//! std::setの代替
template <class Key, class Compare = std::less<Key>>
using set = std::set<Key, Compare, Allocator<Key>>;

//! std::multisetの代替
template <class Key, class Compare = std::less<Key>>
using multiset = std::multiset<Key, Compare, Allocator<Key>>;

//! std::unordered_mapの代替
template <class Key, class T, class Hash = std::hash<Key>, class Pred = std::equal_to<Key>>
using unordered_map = std::unordered_map<Key, T, Hash, Pred, Allocator<std::pair<const Key, T>>>;

//! std::unordered_multimapの代替
template <class Key, class T, class Hash = std::hash<Key>, class Pred = std::equal_to<Key>>
using unordered_multimap = std::unordered_multimap<Key, T, Hash, Pred, Allocator<std::pair<const Key, T>>>;

//! std:unordered_setの代替
template <class Key, class Hash = std::hash<Key>, class Pred = std::equal_to<Key>>
using unordered_set = std::unordered_set<Key, Hash, Pred, Allocator<Key>>;

//! std:unordered_multisetの代替
template <class Key, class Hash = std::hash<Key>, class Pred = std::equal_to<Key>>
using unordered_multiset = std::unordered_multiset<Key, Hash, Pred, Allocator<Key>>;

}   // namespace MGL::STL


#endif	// INCGUARD_MGL_STL_CONTAINERS_H_1651242469

// vim: et ts=4 sw=4 sts=4
