// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_savedata_chunk_register.h
 *  \brief      MGL セーブデータチャンク登録クラス
 *  \date       Since: August 11, 2021. 7:07:38 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_SAVEDATA_CHUNK_REGISTER_H_1628633258
#define INCGUARD_MGL_SAVEDATA_CHUNK_REGISTER_H_1628633258

#include <mgl/savedata/mgl_savedata_chunk.h>
#include <mgl/stl/mgl_stl_containers.h>

namespace MGL::Savedata
{
//! セーブデータチャンク登録クラス
class ChunkRegister final
{
public:
    ChunkRegister(Chunk *chunk) noexcept;
    ~ChunkRegister() noexcept;

    bool Register(DataIdentifier identifier) noexcept;
    bool Unregister(DataIdentifier identifier) noexcept;

private:
    Chunk *_chunk;
    STL::list<DataIdentifier> _identifiers;
};
}    // namespace MGL::Savedata

#endif    // INCGUARD_MGL_SAVEDATA_CHUNK_REGISTER_H_1628633258

// vim: et ts=4 sw=4 sts=4
