// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_savedata_chunk.h
 *  \brief      MGL セーブデータチャンク
 *  \date       Since: August 5, 2021. 8:40:45 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_SAVEDATA_CHUNK_H_1628120445
#define INCGUARD_MGL_SAVEDATA_CHUNK_H_1628120445

#include <mgl/common/mgl_byte_stream.h>
#include <mgl/savedata/mgl_savedata_defs.h>

namespace MGL::Savedata
{
//! セーブデータチャンク
class Chunk
{
public:
    virtual ~Chunk() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      チャンクの識別子を取得
     *  \param[in]  dataIdentifier  セーブデータの識別子
     *  \return     チャンクの識別子
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual ChunkIdentifier GetSavedataChunkIdentifier(DataIdentifier dataIdentifier) const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      チャンクのバージョンを取得
     *  \param[in]  dataIdentifier  セーブデータの識別子
     *  \return     チャンクのバージョン
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual uint32_t GetSavedataChunkVersion(DataIdentifier dataIdentifier) const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief          セーブ実行時の処理
     *  \param[in,out]  stream          データの保存先のストリーム
     *  \param[in]      dataIdentifier  セーブデータの識別子
     *  \retval         true            成功
     *  \retval         false           失敗
     */
    /* ------------------------------------------------------------------------- */
    virtual bool OnSaving(MGL::ByteStream &stream, DataIdentifier dataIdentifier) noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief          ロード実行時の処理
     *  \param[in,out]  stream          読み込むデータが格納されたストリーム
     *  \param[in]      dataIdentifier  セーブデータの識別子
     *  \param[in]      version         チャンクのバージョン
     *  \param[in]      chunkSize       チャンクのサイズ
     *  \retval         true            成功
     *  \retval         false           失敗
     */
    /* ------------------------------------------------------------------------- */
    virtual bool OnLoading(MGL::ByteStream &stream, DataIdentifier dataIdentifier, uint32_t version, size_t chunkSize) noexcept = 0;
};
}   // namespace MGL::Savedata

#endif	// INCGUARD_MGL_SAVEDATA_CHUNK_H_1628120445

// vim: et ts=4 sw=4 sts=4
