// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_texture_with_bounds.h
 *  \brief      MGL 領域付きテクスチャ
 *  \date       Since: July 17, 2021. 13:05:43 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_TEXTURE_WITH_BOUNDS_H_1626494743
#define INCGUARD_MGL_TEXTURE_WITH_BOUNDS_H_1626494743

#include <utility>

#include <mgl/render/mgl_texture.h>

namespace MGL::Render
{
//! 領域付きテクスチャクラス
class TextureWithBounds
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     */
    /* ------------------------------------------------------------------------- */
    constexpr TextureWithBounds() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     *  \param[in]  texture     テクスチャ
     *  \param[in]  bound       領域
     */
    /* ------------------------------------------------------------------------- */
    TextureWithBounds(Texture texture, const Rectangle &bound) noexcept
        : _texture(std::move(texture))
        , _bounds(bound)
    {}

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      テクスチャを取得
     *  \return     テクスチャ
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr const Texture &GetTexture() const noexcept
    {
        return _texture;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      領域を取得
     *  \return     領域
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr const Rectangle &GetBounds() const noexcept
    {
        return _bounds;
    }

private:
    Texture _texture;
    Rectangle _bounds;
};
}    // namespace MGL::Render

#endif    // INCGUARD_MGL_TEXTURE_WITH_BOUNDS_H_1626494743

// vim: et ts=4 sw=4 sts=4
