// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_texture_generator.h
 *  \brief      MGL テクスチャ生成クラス
 *  \date       Since: March 18, 2021. 15:48:19 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_TEXTURE_GENERATOR_H_1616050099
#define INCGUARD_MGL_TEXTURE_GENERATOR_H_1616050099

#include <mgl/render/mgl_texture_resource.h>

namespace MGL::Render
{
//! テクスチャ生成クラス
class TextureGenerator
{
public:
    virtual ~TextureGenerator() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      テクスチャリソースの生成
     *  \return     生成されたテクスチャリソース
     */
    /* ------------------------------------------------------------------------- */
    virtual SharedTextureResource MakeTextureResource() noexcept = 0;
};
}    // namespace MGL::Render
#endif    // INCGUARD_MGL_TEXTURE_GENERATOR_H_1616050099

// vim: et ts=4 sw=4 sts=4
