// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_render.h
 *  \brief      MGL 描画関連ヘッダ
 *  \date       Since: February 8, 2021. 17:12:47 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_RENDER_H_1612771967
#define INCGUARD_MGL_RENDER_H_1612771967

#include <mgl/mgl_environment.h>
#include <mgl/render/font/mgl_font.h>
#include <mgl/render/mgl_renderer_2d.h>
#include <mgl/render/mgl_renderer_set.h>
#include <mgl/render/mgl_texture.h>

namespace MGL::Render
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      2Dレンダラの取得
 *  \return     2Dレンダラ
 */
/* ------------------------------------------------------------------------- */
inline Renderer2DDelegate &GetRenderer2D() noexcept
{
    return RendererSet::GetInstance().GetRenderer2D();
}

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      フォントストレージの取得
 *  \return     フォントストレージ
 */
/* ------------------------------------------------------------------------- */
inline FontStorage &GetFontStorage() noexcept
{
    return FontStorage::GetInstance();
}

}    // namespace MGL::Render

#endif    // INCGUARD_MGL_RENDER_H_1612771967

// vim: et ts=4 sw=4 sts=4
