// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metal_shader_types.h
 *  \brief      Metalシェーダ用型定義
 *  \date       Since: November 4, 2020. 14:47:59 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METAL_SHADER_TYPES_H_1604468879
#define INCGUARD_MGL_METAL_SHADER_TYPES_H_1604468879

#include <simd/simd.h>

//! ライン用の頂点シェーダに渡す頂点バッファのインデックス
enum LineShaderInput
{
    kLineShaderInputVertices,           //!< 頂点
    kLineShaderInputProjectionMatrix,   //!< 投影変換行列
};

//! ライン用頂点情報
struct LineShaderVertex
{
    vector_float2 position; //!< 位置
    vector_float4 color;    //!< 色
};

//! 平面用頂点情報
struct PlaneModelVertex
{
    vector_float2 position;     //!< 位置
    int textureCoordIndex[2];   //!< テクスチャ座標の参照先インデックス
};

//! 矩形用の頂点シェーダに渡す頂点バッファのインデックス
enum RectangleShaderInput
{
    kRectangleShaderInputVertices,            //!< 頂点
    kRectangleShaderInputAttribute,           //!< 描画アトリビュート
    kRectangleShaderInputProjectionMatrix,    //!< 投影変換行列
};

//! 矩形用描画アトリビュート
struct RectangleAttribute
{
    vector_float2   offset;     //!< オフセット
    vector_float2   scale;      //!< スケール
    vector_float4   color;      //!< 色
    vector_float2   pivot;      //!< 回転ピボット
    float           rotate;     //!< 回転角度
};

//! スプライト用の頂点シェーダに渡す頂点バッファのインデックス
enum SpriteShaderInput
{
    kSpriteShaderInputVertices,           //!< 頂点
    kSpriteShaderInputAttribute,          //!< 描画アトリビュート
    kSpriteShaderInputProjectionMatrix,   //!< 投影変換行列
};

//! スプライト用描画アトリビュート
struct SpriteAttribute
{
    vector_float2   offset;             //!< オフセット
    vector_float2   scale;              //!< スケール
    vector_float4   color;              //!< 色
    float           textureCoord[4];    //!< テクスチャの座標
    float           rotate;             //!< 回転角度
    float           flipX;              //!< X方向のフリップ（1.0から-1.0）
    float           flipY;              //!< Y方向のフリップ（1.0から-1.0)
    vector_float2   pivot;              //!< 回転ピボット
};

#endif // INCGUARD_MGL_METAL_SHADER_TYPES_H_1604468879

// vim: et ts=4 sw=4 sts=4
