// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metalkit_texture_loader.h
 *  \brief      MGL MetalKitによるテクスチャローダー
 *  \date       Since: December 12, 2020. 22:22:27 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METALKIT_TEXTURE_LOADER_H_1607779347
#define INCGUARD_MGL_METALKIT_TEXTURE_LOADER_H_1607779347

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_METAL)

#include <mgl/render/mgl_texture_loader.h>

namespace MGL::Render::Metal
{
//! MGL MetalKitによるテクスチャローダー
class MetalKitTextureLoader : public MGL::Render::TextureLoader
{
public:
    //! このテクスチャローダーのキー
    static constexpr TextureLoaderKey kLoaderKey = MakeTextureLoaderKey("MGL-MetalKitLoader");
    
    virtual bool Load(MGL::Render::TextureResource &textureResource, const File::PathView &path) noexcept override;
    virtual bool Load(MGL::Render::TextureResource &textureResource, const void *imageData, size_t dataSize) noexcept override;
};
}   // namespace MGL::Render::Metal

#endif  // MGL_RENDERER_ENABLE_METAL
#endif	// INCGUARD_MGL_METALKIT_TEXTURE_LOADER_H_1607779347

// vim: et ts=4 sw=4 sts=4
