// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metal_texture_resource.h
 *  \brief      MGL Metal用テクスチャリソース
 *  \date       Since: December 8, 2020. 15:27:15 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METAL_TEXTURE_RESOURCE_H_1607408835
#define INCGUARD_MGL_METAL_TEXTURE_RESOURCE_H_1607408835

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_METAL)

#include <mgl/render/metal/mgl_metal_defs.h>

#include <mgl/stl/mgl_stl_memory.h>
#include <mgl/render/mgl_texture_resource.h>
#if defined(__OBJC__)
#include <MetalKit/MetalKit.h>
#include <mgl/render/metal/mgl_metal_render_target.h>
#endif

namespace MGL::Render::Metal
{
//! Metal用テクスチャリソース
class TextureResource : public MGL::Render::TextureResource
{
public:
    TextureResource() noexcept;
#if defined(__OBJC__)
    TextureResource(bool isMainRenderTarget) noexcept;
#endif
    ~TextureResource() noexcept;
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      リソースがどのレンダラ用のものかを返す
     *  \return     レンダラの種類
     */
    /* ------------------------------------------------------------------------- */
    virtual MGL::Render::RendererType GetRendererType() const noexcept override
    {
        return kRendererTypeMetal;
    }
    
    virtual bool IsValid() const noexcept override;
    virtual bool IsRenderTarget() const noexcept override;
    
    virtual bool Create(const void *pixelData, PixelFormat pixelFormat, uint32_t width, uint32_t height) noexcept override;
    virtual bool CreateRenderTarget(uint32_t width, uint32_t height) noexcept override;
    
    virtual void Destroy() noexcept override;
    
    virtual Vector2 GetSize() const noexcept override;
    virtual PixelFormat GetPixelFormat() const noexcept override;
    
#if defined(__OBJC__)
    bool Create(id<MTLTexture> texture) noexcept;
    id<MTLTexture> GetTexture() const noexcept;
    MGLMetalRenderTarget *GetRenderTarget() const noexcept;
#endif
    
private:
#if defined(__OBJC__)
    MTLPixelFormat GetMetalPixelFormat(PixelFormat pixelFormat) const noexcept;
#endif
    
#if defined(__OBJC__)
    //! Metal用のテクスチャリソース
    struct MetalTextureResource
    {
        id<MTLTexture>  texture;            //!< テクスチャ
        MGLMetalRenderTarget *renderTarget; //!< レンダーターゲット
        bool isMainRenderTarget;
        
        //! 初期化用コンストラクタ
        MetalTextureResource() noexcept
            : texture(nil)
            , renderTarget(nil)
            , isMainRenderTarget(false)
        {}
    };
#else
    struct MetalTextureResource;
#endif
    
    STL::unique_ptr<MetalTextureResource> _derivedData;
};
}   // namespace MGL::Render::Metal
#endif  // MGL_RENDERER_ENABLE_METAL
#endif	// INCGUARD_MGL_METAL_TEXTURE_RESOURCE_H_1607408835

// vim: et ts=4 sw=4 sts=4
