// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metal_texture_generator.h
 *  \brief      MGL Metal用テクスチャジェネレータクラス
 *  \date       Since: March 18, 2021. 15:50:25 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METAL_TEXTURE_GENERATOR_H_1616050225
#define INCGUARD_MGL_METAL_TEXTURE_GENERATOR_H_1616050225

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_METAL)

#include <mgl/render/mgl_texture_generator.h>
#include <mgl/render/metal/mgl_metal_texture_resource.h>

namespace MGL::Render::Metal
{
//! MGL Metal用テクスチャジェネレータクラス
class TextureGenerator : public MGL::Render::TextureGenerator
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      テクスチャリソースの生成
     *  \return     生成されたテクスチャリソース
     */
    /* ------------------------------------------------------------------------- */
    virtual SharedTextureResource MakeTextureResource() noexcept override
    {
        return STL::make_shared<MGL::Render::Metal::TextureResource>();
    }
};
}   // namespace MGL::Render::Metal

#endif  // MGL_RENDERER_ENABLE_METAL
#endif	// INCGUARD_MGL_METAL_TEXTURE_GENERATOR_H_1616050225

// vim: et ts=4 sw=4 sts=4
