// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metal_sprite_renderer.h
 *  \brief      MGL Metal用スプライトレンダラ
 *  \date       Since: December 13, 2020. 0:44:03 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METAL_SPRITE_RENDERER_H_1607787843
#define INCGUARD_MGL_METAL_SPRITE_RENDERER_H_1607787843

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_METAL)

#include <mgl/render/mgl_object_renderer.h>
#include <mgl/render/metal/shader/mgl_metal_shader_types.h>
#include <mgl/render/metal/mgl_metal_texture_resource.h>
#include <array>

namespace MGL::Render::Metal
{

namespace
{
}

//! MGL Metal用スプライトレンダラクラス
class SpriteRenderer : public MGL::Render::ObjectRenderer
{
public:
    SpriteRenderer() noexcept;
    
    virtual void Flush() noexcept override;
    
    void AddAttribute(const SpriteAttribute &attribute, SharedTextureResource &textureResource, SamplerType sampler, bool isEnabledBlending) noexcept;
    
private:
    static constexpr size_t kSpriteAttributeMax = 512;     //!< スプライトの最大登録数
    SpriteAttribute *_attributes;
    STL::unique_ptr<SpriteAttribute []> _backupAttributesPtr;
    size_t _attributeCount;
    SharedTextureResource _currentTextureResource;
    SamplerType _currentSampler;
    bool _isEnabledBlending;
};
}   // MGL::Render::Metal

#endif  // MGL_RENDERER_ENABLE_METAL
#endif	// INCGUARD_MGL_METAL_SPRITE_RENDERER_H_1607787843

// vim: et ts=4 sw=4 sts=4
