// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metal_renderer_2d.h
 *  \brief      MGL Metal 2Dレンダラ
 *  \date       Since: November 29, 2020. 12:03:58 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METAL_RENDERER_2D_H_1606619038
#define INCGUARD_MGL_METAL_RENDERER_2D_H_1606619038

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_METAL)

#include <mgl/render/metal/mgl_metal_defs.h>
#include <mgl/render/metal/mgl_metal_line_renderer.h>
#include <mgl/render/metal/mgl_metal_rectangle_renderer.h>
#include <mgl/render/metal/mgl_metal_sprite_renderer.h>
#include <mgl/render/mgl_object_renderer.h>
#include <mgl/render/mgl_renderer_2d_delegate.h>
#include <mgl/event/mgl_event.h>

namespace MGL::Render::Metal
{
//! Metal用2Dレンダラクラス
class Renderer2D : public MGL::Render::Renderer2DDelegate
{
public:
    Renderer2D() noexcept;
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief  レンダラタイプを取得
     *  \return レンダラタイプ
     */
    /* ------------------------------------------------------------------------- */
    virtual RendererType GetRendererType() const noexcept override
    {
        return kRendererTypeMetal;
    }
    
    virtual bool CanInitialize() const noexcept override;
    virtual bool Initialize() noexcept override;
    virtual void Flush() noexcept override;
    
    virtual void Clear(const Color &color) noexcept override;
    
    virtual void DrawLine(const Vector2 &start, const Vector2 &end, const Color &color) noexcept override;
    virtual void DrawRectangle(const Rectangle &rectangle, const Color &color, const DrawOption2D &option) noexcept override;
    virtual void DrawSprite(
            const Vector2 &position,
            SharedTextureResource textureResource,
            const Rectangle &sourceRectangle,
            const DrawOption2D &option) noexcept override;
    
    virtual bool SetRenderTarget(SharedTextureResource renderTarget) noexcept override;
    virtual SharedTextureResource GetRenderTarget() const noexcept override;
    virtual SharedTextureResource GetMainRenderTarget() const noexcept override;
    
    virtual void SetScissor(bool isEnabled, const Rectangle &rectangle) noexcept override;
    virtual bool IsEnabledScissor() const noexcept override;
    virtual Rectangle GetScissorRectangle() const noexcept override;

private:
    void ChangeObjectRenderer(MGL::Render::ObjectRenderer *objectRenderer) noexcept;
    void AdjustAlignment(vector_float2 &offset, const Vector2 &size, const DrawOption2D &option) const noexcept;
    
    static void CallbackPostFrameUpdate(void *callbackArg, void *notifyArg) noexcept;

    Event::Handle _eventPostFrameUpdate;
    
    MGL::Render::ObjectRenderer *_currentObjectRenderer;
    LineRenderer _lineRenderer;
    RectangleRenderer _rectangleRenderer;
    SpriteRenderer _spriteRenderer;
    
    SharedTextureResource _mainRenderTarget;
    SharedTextureResource _currentRenderTarget;
};
}   // namespce MGL::Render::Metal

#endif  // MGL_RENDERER_ENABLE_METAL
#endif	// INCGUARD_MGL_METAL_RENDERER_2D_H_1606619038

// vim: et ts=4 sw=4 sts=4
