// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metal_renderer.h
 *  \brief      Metalレンダラ
 *  \date       Since: November 3, 2020. 16:45:07 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METAL_RENDERER_H_1604389507
#define INCGUARD_MGL_METAL_RENDERER_H_1604389507

#import <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_METAL)

#import <MetalKit/MetalKit.h>
#import <mgl/render/metal/shader/mgl_metal_shader_types.h>
#import <mgl/render/metal/mgl_metal_render_target.h>
#import <mgl/render/mgl_render_types.h>

//! Metal用レンダラクラス
@interface MGLMetalRenderer : NSObject<MTKViewDelegate>

@property (nonatomic, nullable, readonly)  MGLMetalRenderTarget *mainRenderTarget;      //!< メインのレンダーターゲット
@property (nonatomic) bool isEnabledScissor;                    //!< シザー矩形の有効フラグ
@property (nonatomic) MTLScissorRect scissorRectangle;          //!< シザー矩形

+ (nullable instancetype)sharedInstance;
- (nonnull instancetype)initWithMetalKitView:(nonnull MTKView *)mtkView;

- (nullable id<MTLTexture>)loadTexture:(nonnull NSString *)filePath;
- (nullable id<MTLTexture>)loadTextureFromMemory:(nonnull const void *)imageData
                                        dataSize:(size_t)dataSize;

- (nullable id<MTLTexture>)createTexture:(nonnull const void *)pixelData
                             pixelFormat:(MTLPixelFormat)pixelFormat
                           pixelPerBytes:(size_t)pixelPerBytes
                                    size:(simd_uint2)size;

- (nullable MGLMetalRenderTarget*)createRenderTarget:(simd_uint2)size;

- (void)setRenderTarget:(nonnull MGLMetalRenderTarget *)renderTarget;

- (nullable id<MTLSamplerState>)getSamplerState:(MGL::Render::SamplerType)sampler;

- (void)clear:(MTLClearColor)color;

- (void)drawLine:(nonnull const LineShaderVertex *)vertices
     vertexCount:(size_t)vertexCount;

- (void)drawRectangle:(nonnull const RectangleAttribute *)attributes
       attributeCount:(size_t)count;

- (void)drawSprite:(nonnull const SpriteAttribute *)attributes
    attributeCount:(size_t)count
           texture:(nonnull const id<MTLTexture>)texture
      samplerState:(nonnull const id<MTLSamplerState>)samplerState
 isEnabledBlending:(bool)isEnabledBlending;

- (nullable void *)reserveDynamicBuffer:(size_t)length;

@end

#endif  // MGL_RENDERER_ENABLE_METAL
#endif  // INCGUARD_MGL_METAL_RENDERER_H_1604389507

// vim: et ts=4 sw=4 sts=4
