// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metal_render_target.h
 *  \brief      Metal用レンダーターゲット
 *  \date       Since: November 14, 2020. 12:33:00 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METAL_RENDER_TARGET_H_1605324780
#define INCGUARD_MGL_METAL_RENDER_TARGET_H_1605324780

#import <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_METAL)

#import <MetalKit/MetalKit.h>

//! Metal用レンダーターゲット
@interface MGLMetalRenderTarget : NSObject

@property (nonatomic, nullable, readonly)  id<MTLTexture> texture;                      //!< テクスチャ
@property (nonatomic, readonly)            MTLViewport    viewport;                     //!< ビューポート
@property (nonatomic, nullable, readonly)  id<MTLBuffer>  orthogonalProjectionMatrix;   //!< 平行投影行列

- (nullable id)init;
- (nullable id)initWithSize:(simd_uint2)size
                pixelFormat:(MTLPixelFormat)pixelFormat
                     device:(nonnull id<MTLDevice>)device
               commandQueue:(nonnull id<MTLCommandQueue>)commandQueue;

- (void)updateWithMetalKitView:(nonnull MTKView *)mtkView
                      viewport:(nonnull MTLViewport *)viewport
    orthogonalProjectionMatrix:(nonnull id<MTLBuffer>)orthogonalProjectionMatrix;

- (nullable MTLRenderPassDescriptor *)renderPassDescriptor;

@end

#endif  // MGL_RENDERER_ENABLE_METAL
#endif  // INCGUARD_MGL_METAL_RENDER_TARGET_H_1605324780

// vim: et ts=4 sw=4 sts=4
