// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metal_rectangle_renderer.h
 *  \brief      MGL Metal用矩形レンダラ
 *  \date       Since: December 1, 2020. 19:45:03 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METAL_RECTANGLE_RENDERER_H_1606819503
#define INCGUARD_MGL_METAL_RECTANGLE_RENDERER_H_1606819503

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_METAL)

#include <mgl/render/mgl_object_renderer.h>
#include <mgl/render/metal/shader/mgl_metal_shader_types.h>
#include <mgl/stl/mgl_stl_memory.h>

namespace MGL::Render::Metal
{
//! MGL Metal用矩形レンダラクラス
class RectangleRenderer : public MGL::Render::ObjectRenderer
{
public:
    RectangleRenderer() noexcept;
    
    virtual void Flush() noexcept override;
    
    void AddAttribute(const RectangleAttribute &attribute) noexcept;
    
private:
    static constexpr size_t kRectangleAttributeMax = 512;  //!< 登録できる矩形の最大数

    RectangleAttribute *_attributes;
    STL::unique_ptr<RectangleAttribute[]> _backupAttributesPtr;
    size_t _attributeCount;
};
}   // MGL::Render::Metal

#endif  // MGL_RENDERER_ENABLE_METAL
#endif	// INCGUARD_MGL_METAL_RECTANGLE_RENDERER_H_1606819503

// vim: et ts=4 sw=4 sts=4
