// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metal_line_renderer.h
 *  \brief      MGL Metal用ラインレンダラ
 *  \date       Since: December 2, 2020. 3:38:21 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METAL_LINE_RENDERER_H_1606847901
#define INCGUARD_MGL_METAL_LINE_RENDERER_H_1606847901

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_METAL)

#include <mgl/common/mgl_color.h>
#include <mgl/math/mgl_vector2.h>
#include <mgl/render/metal/shader/mgl_metal_shader_types.h>
#include <mgl/render/mgl_object_renderer.h>
#include <mgl/stl/mgl_stl_memory.h>

namespace MGL::Render::Metal
{

namespace
{
}

//! Metal用ラインレンダラ
class LineRenderer : public MGL::Render::ObjectRenderer
{
public:
    LineRenderer() noexcept;
    
    virtual void Flush() noexcept override;
    
    void Add(const Vector2 &start, const Vector2 &end, const Color &color) noexcept;
    
private:
    static constexpr size_t kLineVertexMax = 512;  //!< 登録できる頂点の最大数（1ラインにつき2頂点消費）
    static_assert((kLineVertexMax % 2) == 0, "kLineVertexMax must be an even number.");    // kLineVertexMaxは偶数である必要がある

    LineShaderVertex *_vertices;
    STL::unique_ptr<LineShaderVertex[]> _backupVerticesPtr;
    size_t _vertexCount;
};
}   // namespace MGL::Render::Metal
#endif  // MGL_RENDERER_ENABLE_METAL
#endif	// INCGUARD_MGL_METAL_LINE_RENDERER_H_1606847901

// vim: et ts=4 sw=4 sts=4
