// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_metal_dynamic_buffers.h
 *  \brief      MGL Metal用動的バッファアレイ
 *  \date       Since: February 13, 2021. 16:56:54 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_METAL_DYNAMIC_BUFFERS_H_1613203014
#define INCGUARD_MGL_METAL_DYNAMIC_BUFFERS_H_1613203014

#import <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_METAL)

#import <Metal/Metal.h>

//! MGL Metal用動的バッファアレイ
@interface MGLMetalDynamicBuffers : NSObject

@property (nonatomic, readonly) size_t bufferCount;             //!< バッファの数
@property (nonatomic, readonly) size_t currentIndex;            //!< 現在のインデックス
@property (nonatomic, readonly) size_t bufferSize;              //!< バッファのサイズ
@property (nonatomic, nonnull) dispatch_semaphore_t semaphore;  //!< 同期用のセマフォ

@property (nonatomic, readonly) size_t currentOffset;           //!< 現在のオフセット
@property (nonatomic, readonly) size_t prevOffset;              //!< 前回の（commitまたはallocateする前の）オフセット
@property (nonatomic, readonly) bool isReserved;                //!< 予約中フラグ
@property (nonatomic, nullable, readonly) void *reserveAddress; //!< 予約中のバッファの開始アドレス

- (nullable id)initWithBufferCount:(size_t)bufferCount
                            length:(size_t)length
                            device:(nonnull id<MTLDevice>)deviec;

- (void)next;
- (nonnull id<MTLBuffer>)currentBuffer;

- (nullable void *)reserve:(size_t)length;
- (bool)commit:(size_t)length;

- (nullable void *)allocate:(size_t)length;

- (size_t)remainSize;

- (bool)isReservedAddress:(nonnull const void *)address;

@end

#endif  // MGL_RENDERER_ENABLE_METAL
#endif	// INCGUARD_MGL_METAL_DYNAMIC_BUFFERS_H_1613203014

// vim: et ts=4 sw=4 sts=4
