// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_font_option.h
 *  \brief      MGL フォント描画オプション
 *  \date       Since: May 26, 2021. 18:10:49 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_FONT_OPTION_H_1622020249
#define INCGUARD_MGL_FONT_OPTION_H_1622020249

#include <mgl/common/mgl_color.h>
#include <mgl/render/mgl_draw_option_2d.h>
#include <mgl/render/mgl_render_types.h>

namespace MGL::Render
{
//! フォント描画オプション
struct FontOption
{
    Vector2 firstPosition;                                                     //!< 初期基準位置
    Alignment::Horizontal horizontalAlignment{Alignment::Horizontal::Left};    //!< 水平方向の配置情報
    Vector2 scale{1.0f, 1.0f};                                        //!< スケール値
    Color maskColor{kColorWhite};                                              //!< マスクカラー
    SamplerType samplerType{SamplerType::Nearest};                             //!< サンプラータイプ
    Vector2 margin;                                                            //!< 字間と行間

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      DrawOption2Dクラスに変換するオペレータ
     *  \return     DrawOption2Dクラス
     */
    /* ------------------------------------------------------------------------- */
    constexpr operator DrawOption2D() const noexcept
    {
        DrawOption2D option;
        option.SetScale(scale);
        option.SetMaskColor(maskColor);
        option.SetSamplerType(samplerType);

        return option;
    }
};

}    // namespace MGL::Render

#endif    // INCGUARD_MGL_FONT_OPTION_H_1622020249

// vim: et ts=4 sw=4 sts=4
