// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_font_glyph.h
 *  \brief      MGL フォントのグリフ情報
 *  \date       Since: April 19, 2023. 0:30:31 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_FONT_GLYPH_H_1681831831
#define INCGUARD_MGL_FONT_GLYPH_H_1681831831

#include <mgl/render/mgl_texture_with_bounds.h>

namespace MGL::Render
{
//! グリフ情報
struct FontGlyph
{
    char32_t code{0};             //!< 文字コード（UTF-32）
    Vector2 size;                 //!< サイズ（幅と高さ）
    float advance{0.0f};          //!< 送り幅
    Vector2 bearing;              //!< ベアリング
    TextureWithBounds texture;    //!< 表示するテクスチャ
};
}    // namespace MGL::Render

#endif    // INCGUARD_MGL_FONT_GLYPH_H_1681831831

// vim: et ts=4 sw=4 sts=4
