// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_d3d11_wic_texture_loader.h
 *  \brief      MGL WICによるテクスチャローダー
 *  \date       Since: March 28, 2021. 3:19:32 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_D3D11_WIC_TEXTURE_LOADER_H_1616869172
#define INCGUARD_MGL_D3D11_WIC_TEXTURE_LOADER_H_1616869172

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_D3D11)

#include <mgl/platform/win32/mgl_win32_com_using.h>
#include <mgl/render/mgl_texture_loader.h>
#include <wincodec.h>
#include <atlbase.h>

namespace MGL::Render::D3D11
{
//! WICによるテクスチャローダー
class WICTextureLoader : public MGL::Render::TextureLoader
{
public:
    //! このテクスチャローダーを表すキー
    static constexpr TextureLoaderKey kLoaderKey = MakeTextureLoaderKey("MGL-WICTextureLoader");

    //! デコード用の関数の型
    using DecodeFunction = bool(*) (Render::TextureResource &textureResource, IWICBitmapFrameDecode *frame) noexcept;

    WICTextureLoader() noexcept;

    bool Load(Render::TextureResource &textureResource, const File::PathView &path) noexcept override;
    bool Load(Render::TextureResource &textureResource, const void *imageData, size_t dataSize) noexcept override;

    static bool Load32bppRGBA(Render::TextureResource &textureResource, IWICBitmapFrameDecode *frame) noexcept;
    static bool Load32bppBGRA(Render::TextureResource &textureResource, IWICBitmapFrameDecode *frame) noexcept;

private:
    bool Initialize() noexcept;

    Win32::ComUsing _comUsing;
    bool _isAvailable{false};
    CComPtr<IWICImagingFactory> _factory{nullptr};
};

}   // namespace MGL::Render::D3D11

#endif  // MGL_RENDERER_ENABLE_D3D11
#endif	// INCGUARD_MGL_D3D11_WIC_TEXTURE_LOADER_H_1616869172

// vim: et ts=4 sw=4 sts=4
