// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_d3d11_texture_generator.h
 *  \brief      MGL Direct3D11用テクスチャジェネレータ
 *  \date       Since: March 27, 2021. 3:43:36 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_D3D11_TEXTURE_GENERATOR_H_1616784216
#define INCGUARD_MGL_D3D11_TEXTURE_GENERATOR_H_1616784216

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_D3D11)

#include <mgl/render/mgl_texture_generator.h>

namespace MGL::Render::D3D11
{
//! MGL Direct3D11用テクスチャジェネレータ
class TextureGenerator : public MGL::Render::TextureGenerator
{
public:
    virtual SharedTextureResource MakeTextureResource() noexcept override;
};
}   // namespace MGL::Render::D3D11

#endif  // MGL_RENDERER_ENABLE_D3D11
#endif	// INCGUARD_MGL_D3D11_TEXTURE_GENERATOR_H_1616784216

// vim: et ts=4 sw=4 sts=4
