// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_d3d11_renderer_2d.h
 *  \brief      MGL Direct3D11 2Dレンダラ
 *  \date       Since: March 1, 2021. 15:43:52 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_D3D11_RENDERER_2D_H_1614581032
#define INCGUARD_MGL_D3D11_RENDERER_2D_H_1614581032

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_D3D11)

#include <atlbase.h>
#include <d3d11_1.h>
#include <mgl/math/mgl_matrix4x4.h>
#include <mgl/render/d3d11/mgl_d3d11_defs.h>
#include <mgl/render/d3d11/mgl_d3d11_line_renderer.h>
#include <mgl/render/d3d11/mgl_d3d11_rectangle_renderer.h>
#include <mgl/render/d3d11/mgl_d3d11_sprite_renderer.h>
#include <mgl/render/mgl_render_types.h>
#include <mgl/render/mgl_renderer_2d_delegate.h>

namespace MGL::Render::D3D11
{
//! MGL Direct3D11 2Dレンダラ
class Renderer2D : public MGL::Render::Renderer2DDelegate
{
public:
    Renderer2D() noexcept;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief  レンダラタイプを取得
     *  \return レンダラタイプ
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] RendererType GetRendererType() const noexcept override
    {
        return kRendererTypeDirect3D11;
    }

    [[nodiscard]] bool CanInitialize() const noexcept override;
    bool Initialize() noexcept override;

    void Flush() noexcept override;
    void Clear(const Color &color) noexcept override;

    void DrawLine(const Vector2 &start, const Vector2 &end, const Color &color) noexcept override;
    void DrawRectangle(const Rectangle &rectangle, const Color &color, const DrawOption2D &option) noexcept override;
    void DrawSprite(
            const Vector2 &position,
            SharedTextureResource textureResource,
            const Rectangle &sourceRectangle,
            const DrawOption2D &option) noexcept override;
    
    bool SetRenderTarget(SharedTextureResource renderTarget) noexcept override;
    [[nodiscard]] SharedTextureResource GetRenderTarget() const noexcept override;
    [[nodiscard]] SharedTextureResource GetMainRenderTarget() const noexcept override;
    
    void SetScissor(bool isEnabled, const Rectangle &rectangle) noexcept override;
    [[nodiscard]] bool IsEnabledScissor() const noexcept override;
    [[nodiscard]] Rectangle GetScissorRectangle() const noexcept override;

private:
    bool InitializeRasterizerState() noexcept;
    bool InitializeBlendState() noexcept;

    ObjectRenderer::FlushParameter GetFlushParameter() noexcept;
    [[nodiscard]] ID3D11Buffer *GetOrthogonalMatrixBuffer() const noexcept;

    void ChangeObjectRenderer(ObjectRenderer *objectRenderer) noexcept;

    static void ApplyAnchor(float *offset, const Vector2 &size, const DrawOption2D &option) noexcept;

    CComPtr<ID3D11RasterizerState>  _mainRasterizerState;
    CComPtr<ID3D11RasterizerState>  _clippedRasterizerState;
    CComPtr<ID3D11BlendState>       _blendState;

    bool        _isEnabledScissor;
    Rectangle   _scissorRectangle;

    SharedTextureResource _mainRenderTarget;
    SharedTextureResource _currentRenderTarget;

    ObjectRenderer *_currentObjectRenderer;
    LineRenderer _lineRenderer;
    RectangleRenderer _rectangleRenderer;
    SpriteRenderer _spriteRenderer;
};
}   // namespace MGL::Render::D3D11

#endif  // MGL_RENDERER_ENABLE_D3D11
#endif	// INCGUARD_MGL_D3D11_RENDERER_2D_H_1614581032

// vim: et ts=4 sw=4 sts=4
