// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_d3d11_object_renderer.h
 *  \brief      MGL Direct3D11用オブジェクトレンダラ基底クラス
 *  \date       Since: March 5, 2021. 17:33:29 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_D3D11_OBJECT_RENDERER_H_1614933209
#define INCGUARD_MGL_D3D11_OBJECT_RENDERER_H_1614933209

#include <mgl/mgl_environment.h>
#if defined(MGL_RENDERER_ENABLE_D3D11)

#include <d3d11_1.h>

namespace MGL::Render::D3D11
{
//! Direct3D11用オブジェクトレンダラ基底クラス
class ObjectRenderer
{
public:
    //! 描画に使用するパラメータ
    struct FlushParameter
    {
        ID3D11Buffer            *matrix;            //!< 変換座標
        ID3D11RasterizerState   *rasterizerState;   //!< ラスタライザステート
        ID3D11BlendState        *blendState;        //!< ブレンドステート
    };

    virtual ~ObjectRenderer() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      初期化処理
     *  \retval     true    成功
     *  \retval     false   失敗
     */
    /* ------------------------------------------------------------------------- */
    virtual bool Initialize() noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      オブジェクトの反映
     *  \param[in]  flushParameter  描画に使用するパラメータ
     */
    /* ------------------------------------------------------------------------- */
    virtual void Flush(const FlushParameter &flushParameter) noexcept = 0;
};
}   // namespace MGL::Render::D3D11

#endif  // MGL_RENDERER_ENABLE_D3D11
#endif	// INCGUARD_MGL_D3D11_OBJECT_RENDERER_H_1614933209

// vim: et ts=4 sw=4 sts=4
