// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_win32_main.h
 *  \brief      MGL Win32用メイン
 *  \date       Since: March 1, 2021. 11:56:10 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_WIN32_MAIN_H_1614567370
#define INCGUARD_MGL_WIN32_MAIN_H_1614567370

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_WIN32)

#include <Windows.h>
#include <mgl/initialize/mgl_initialize.h>
#include <mgl/platform/win32/mgl_win32_window.h>

namespace MGL::Win32
{
int Main(
    HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    LPSTR lpCmdLine,
    int nCmdShow,
    MGL::InitializerDelegate &initializer,
    const Window::Descriptor &windowDescriptor,
    MakeAppDelegateFunction makeDelegate) noexcept;

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      デリゲートを指定してメイン関数を生成するテンプレート関数
 *  \tparam     T                   生成するアプリケーションデリゲート
 *  \param[in]  hInstance           アプリケーションインスタンス
 *  \param[in]  hPrevInstance       未使用
 *  \param[in]  lpCmdLine           未使用
 *  \param[in]  nCmdShow            ウィンドウの表示状態
 *  \param[in]  initializer         MGLイニシャライザ
 *  \param[in]  windowDescriptor    ウィンドウ初期化用記述子
 *  \return     終了コード
 */
/* ------------------------------------------------------------------------- */
template <class T>
constexpr int Main(
    HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    LPSTR lpCmdLine,
    int nCmdShow,
    MGL::InitializerDelegate &initializer,
    const Window::Descriptor &windowDescriptor = Window::Descriptor()) noexcept
{
    return Main(hInstance, hPrevInstance, lpCmdLine, nCmdShow, initializer, windowDescriptor, [](STL::unique_ptr<ApplicationDelegate> &appDelegate)
    {
        appDelegate = STL::make_unique<T>();
    });
}
}   // namespace MGL::Win32

#endif  // MGL_TARGET_WIN32
#endif	// INCGUARD_MGL_WIN32_MAIN_H_1614567370

// vim: et ts=4 sw=4 sts=4
