// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_win32_com_using.h
 *  \brief      MGL COMを使用するためのオブジェクト
 *  \date       Since: March 28, 2021. 7:47:48 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_WIN32_COM_USING_H_1616885268
#define INCGUARD_MGL_WIN32_COM_USING_H_1616885268

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_WIN32)

#include <Windows.h>

namespace MGL::Win32
{
//! COMを使用するためのオブジェクト
class ComUsing
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     *  \param[in]  initMode    初期化モード
     */
    /* ------------------------------------------------------------------------- */
    ComUsing(COINIT initMode = COINIT_APARTMENTTHREADED) noexcept
        : _isValid(false)
    {
        auto hr = CoInitializeEx(nullptr, initMode);
        if ((hr == S_OK) || (hr == S_FALSE))
        {
            _isValid = true;
        }
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      デストラクタ
     */
    /* ------------------------------------------------------------------------- */
    ~ComUsing() noexcept
    {
        if (_isValid)
        {
            CoUninitialize();
            _isValid = false;
        }
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      COMが利用可能かを取得
     *  \retval     true    利用可能
     *  \retval     false   利用不可能
     */
    /* ------------------------------------------------------------------------- */
    bool IsValid() noexcept
    {
        return _isValid;
    }

private:
    bool _isValid;
};
}

#endif  // MGL_TARGET_WIN32
#endif	// INCGUARD_MGL_WIN32_COM_USING_H_1616885268

// vim: et ts=4 sw=4 sts=4
