// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_apple_metal_view_controller.h
 *  \brief      MGL Metalビューコントローラ
 *  \date       Since: November 3, 2020. 17:10:53 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_APPLE_METAL_VIEW_CONTROLLER_H_1604391053
#define INCGUARD_MGL_APPLE_METAL_VIEW_CONTROLLER_H_1604391053

#import <MetalKit/MetalKit.h>

#import <mgl/mgl_environment.h>

#if defined(MGL_TARGET_MACOS)
    #import <mgl/platform/apple/macos/mgl_macos_view_controller.h>

    @interface MGLMetalViewController : MGLmacOSViewController
    @end
#elif defined(MGL_TARGET_IOS)
    #import <mgl/platform/apple/ios/mgl_ios_view_controller.h>

    @interface MGLMetalViewController : MGLiOSViewController
    @end
#elif defined(MGL_TARGET_TVOS)
    #import <mgl/platform/apple/tvos/mgl_tvos_view_controller.h>

    @interface MGLMetalViewController : MGLtvOSViewController
    @end
#endif

#endif // INCGUARD_MGL_APPLE_METAL_VIEW_CONTROLLER_H_1604391053

// vim: et ts=4 sw=4 sts=4
