// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_macos_static_info.h
 *  \brief      MGL macOSのMGL初期化前に取得可能な情報
 *  \date       Since: July 10, 2022. 3:59:29 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_MACOS_STATIC_INFO_H_1657393169
#define INCGUARD_MGL_MACOS_STATIC_INFO_H_1657393169

#include <mgl/mgl_environment.h>

#if defined(MGL_TARGET_MACOS)

#include <string>

namespace MGL::Platform::MacOS
{
std::string GetExecutablePath(bool isDirectoryOnly = false) noexcept;
std::string GetFrameworkPath() noexcept;
}   // namespage MGL::Platform::MacOS

#endif  // MGL_TARGET_MACOS
#endif	// INCGUARD_MGL_MACOS_STATIC_INFO_H_1657393169

// vim: et ts=4 sw=4 sts=4
