// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_environment.h
 *  \brief      MGL 環境定義
 *  \date       Since: December 9, 2020. 16:07:57 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_ENVIRONMENT_H_1607497677
#define INCGUARD_MGL_ENVIRONMENT_H_1607497677

#if defined(MGL_TARGET_CORE_ONLY)

#else

    #if __APPLE__
    #include <TargetConditionals.h>
    #endif
    
    // macOS
    #if __APPLE__ && TARGET_OS_OSX
        // ターゲット
        #define MGL_TARGET_MACOS                            //!< macOS
    
        // 使用可能な描画エンジン
        #define MGL_RENDERER_ENABLE_METAL                   //!< Metal
    
        // キーボード入力
        #define MGL_KEYBOARD_DELEGATE_ENABLE_EVENT          //!< イベントによるキーボードデリゲートを使用
    
        // マウス入力
        #define MGL_MOUSE_DELEGATE_ENABLE_MACOS             //!< macOS用マウスデリゲートを使用
    
        // ゲームパッド入力
        #define MGL_GAMEPAD_DELEGATE_ENABLE_MFI             //!< MFiゲームパッドを有効化
        #define MGL_GAMEPAD_DELEGATE_ENABLE_APPLE_GC        //!< Apple GameControllerフレームワークのゲームパッドを有効化
        #define MGL_GAMEPAD_DELEGATE_ENABLE_IOKIT_HID       //!< IOKitによるHIDゲームパッドを有効化
    
        // ファイルデリゲート
        #define MGL_FILE_DELEGATE_ENABLE_POSIX              //!< POSIX準拠
        #define MGL_FILE_DELEGATE_ENABLE_NSFILE             //!< Apple環境向け
    
        // 使用するオーディオエンジン
        #define MGL_AUDIO_RENDERER_ENABLE_APPLE_COREAUDIO   //!< CoreAudio
    
        // デバッグ有効定義
        #if (DEBUG == 1)
            #define MGL_DEBUG
        #endif
    
    // iOS/iPadOS
    #elif __APPLE__ && TARGET_OS_IOS
        // ターゲット
        #define MGL_TARGET_IOS                              //!< iOS/tvOS
    
        // 使用可能な描画エンジン
        #define MGL_RENDERER_ENABLE_METAL                   //!< Metal
    
        // 使用可能な入力デバイス
        #define MGL_INPUT_ENABLE_GAMEPAD                    //!< ゲームパッド
        #define MGL_INPUT_ENABLE_TOUCH                      //!< タッチ
    
        // ゲームパッド入力
        #define MGL_GAMEPAD_DELEGATE_ENABLE_MFI             //!< MFiゲームパッドを有効化
        #define MGL_GAMEPAD_DELEGATE_ENABLE_APPLE_GC        //!< Apple GameControllerフレームワークのゲームパッドを有効化
    
        // タッチ入力
        #define MGL_TOUCH_DELEGATE_ENABLE_EVENT             //!< イベントによるタッチデリゲートを使用
    
        // ファイルデリゲート
        #define MGL_FILE_DELEGATE_ENABLE_NSFILE             //!< Apple環境向け
    
        // 使用するオーディオエンジン
        #define MGL_AUDIO_RENDERER_ENABLE_APPLE_COREAUDIO   //!< CoreAudio
    
        // デバッグ有効定義
        #if (DEBUG == 1)
            #define MGL_DEBUG
        #endif
    
    // tvOS
    #elif __APPLE__ && TARGET_OS_TV
        // ターゲット
        #define MGL_TARGET_TVOS                             //!< tvOS
    
        // 使用可能な描画エンジン
        #define MGL_RENDERER_ENABLE_METAL                   //!< Metal
    
        // 使用可能な入力デバイス
        #define MGL_INPUT_ENABLE_GAMEPAD                    //!< ゲームパッド
    
        // ゲームパッド入力
        #define MGL_GAMEPAD_DELEGATE_ENABLE_MFI             //!< MFiゲームパッドを有効化
        #define MGL_GAMEPAD_DELEGATE_ENABLE_APPLE_GC        //!< Apple GameControllerフレームワークのゲームパッドを有効化
    
        // ファイルデリゲート
        #define MGL_FILE_DELEGATE_ENABLE_NSFILE             //!< Apple環境向け
    
        // 使用するオーディオエンジン
        #define MGL_AUDIO_RENDERER_ENABLE_APPLE_COREAUDIO   //!< CoreAudio
    
        // デバッグ有効定義
        #if (DEBUG == 1)
            #define MGL_DEBUG
        #endif
    
    // Win32（Win64も含む）
    #elif defined(_WIN32)
        // ターゲット
        #define MGL_TARGET_WIN32                        //!< Win32
    
        // 使用可能な描画エンジン
        #define MGL_RENDERER_ENABLE_D3D11               //!< Direct3D11
    
        // キーボード入力
        #define MGL_KEYBOARD_DELEGATE_ENABLE_WIN32      //!< Win32キーボードデリゲートを使用
    
        // マウス入力
        #define MGL_MOUSE_DELEGATE_ENABLE_WIN32         //!< Win32マウスデリゲートを使用
    
        // ゲームパッド入力
        #define MGL_GAMEPAD_DELEGATE_ENABLE_XINPUT      //!< XInputによるゲームパッドを有効化
        #define MGL_GAMEPAD_DELEGATE_ENABLE_DIRECTINPUT //!< DirectInputによるゲームパッドを有効化
    
        // ファイルデリゲート
        #define MGL_FILE_DELEGATE_ENABLE_WIN32          //!< Win32
    
        // 使用するオーディオエンジン
        #define MGL_AUDIO_RENDERER_ENABLE_XAUDIO2       //!< XAudio2
    
        // デバッグ有効定義
        #if defined(_DEBUG)
            #define MGL_DEBUG
        #endif
    
    // 上記以外
    #else
        #define MGL_TARGET_UNKNOWN      //!< ターゲット不明
    #endif

#endif

// C++23以降で constexpr になるマクロの定義（C++23に完全移行するまでの繋ぎ）
#if __cplusplus >= 202302L
    #define MGL_MAYBE_CONSTEXPR constexpr
#else
    #define MGL_MAYBE_CONSTEXPR
#endif

#endif	// INCGUARD_MGL_ENVIRONMENT_H_1607497677

// vim: et ts=4 sw=4 sts=4
