// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_application_delegate.h
 *  \brief      MGL アプリケーションデリゲート
 *  \date       Since: November 28, 2020. 19:23:56 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_APPLICATION_DELEGATE_H_1606559036
#define INCGUARD_MGL_APPLICATION_DELEGATE_H_1606559036

#include <mgl/event/mgl_event.h>

namespace MGL
{
//! MGLアプリケーションデリゲートクラス
class ApplicationDelegate
{
public:
    ApplicationDelegate() noexcept;
    virtual ~ApplicationDelegate() noexcept = default;
    
    bool Initialize() noexcept;
    
protected:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      アプリケーション初期化処理
     *  \retval     true    初期化成功
     *  \retval     false   初期化失敗
     */
    /* ------------------------------------------------------------------------- */
    virtual bool OnInitialize() noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      アプリケーションのフレーム更新処理
     */
    /* ------------------------------------------------------------------------- */
    virtual void OnFrameUpdate() noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      アプリケーションの終了処理
     */
    /* ------------------------------------------------------------------------- */
    virtual void OnExit() noexcept = 0;
    
private:
    static void OnEventAppInitialize(void *callbackArg, void *notifyArg) noexcept;
    static void OnEventAppFrameUpdate(void *callbackArg, void *notifyArg) noexcept;
    static void OnEventAppExit(void *callbackArg, void *notifyArg) noexcept;
    
    bool _isAvailable{false};
    
    Event::Handle _eventAppInitialize;
    Event::Handle _eventAppFrameUpdate;
    Event::Handle _eventAppExit;
};
}   // namespace MGL

#endif	// INCGUARD_MGL_APPLICATION_DELEGATE_H_1606559036

// vim: et ts=4 sw=4 sts=4
