// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_memory.h
 *  \brief      MGL メモリ関連
 *  \date       Since: April 29, 2022. 20:27:43 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_MEMORY_H_1651231663
#define INCGUARD_MGL_MEMORY_H_1651231663

#include <mgl/memory/mgl_memory_default_allocator.h>

namespace MGL::Memory
{
bool SetDefaultAllocator(const DefaultAllocator::Configuration &config) noexcept;
bool SetAllocator(Allocator *allocator) noexcept;
[[nodiscard]] void *Allocate(size_t size) noexcept;
void Deallocate(void *buffer) noexcept;
void *Reallocate(void *buffer, size_t newSize) noexcept;

bool IsAvailableAllocator() noexcept;

AllocatorType GetAllocatorType() noexcept;
bool GetSizeInfo(size_t &dest, uint32_t key, uint32_t arg = 0) noexcept;
}    // namespace MGL::Memory

#endif    // INCGUARD_MGL_MEMORY_H_1651231663

// vim: et ts=4 sw=4 sts=4
