// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_vector4.h
 *  \brief      MGL 4Dベクトル
 *  \date       Since: March 2, 2021. 13:27:42 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_VECTOR4_H_1614659262
#define INCGUARD_MGL_VECTOR4_H_1614659262

namespace MGL
{
//! 4Dベクトル
struct Vector4
{
    float x;    //!< X成分
    float y;    //!< Y成分
    float z;    //!< Z成分
    float w;    //!< W成分

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ゼロ初期化
     */
    /* ------------------------------------------------------------------------- */
    constexpr Vector4() noexcept
        : x(0.0f)
        , y(0.0f)
        , z(0.0f)
        , w(0.0f)
    {}

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      成分を指定して初期化
     *  \param[in]  inX     X成分
     *  \param[in]  inY     Y成分
     *  \param[in]  inZ     Z成分
     *  \param[in]  inW     W成分
     */
    /* ------------------------------------------------------------------------- */
    constexpr Vector4(float inX, float inY, float inZ, float inW) noexcept
        : x(inX)
        , y(inY)
        , z(inZ)
        , w(inW)
    {}
};

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      Vector4の加算
 *  \param[in]  lhs     左辺
 *  \param[in]  rhs     右辺
 *  \return     加算結果
 */
/* ------------------------------------------------------------------------- */
constexpr Vector4 operator+(const Vector4 &lhs, const Vector4 &rhs) noexcept
{
    return Vector4(lhs.x + rhs.x,
                   lhs.y + rhs.y,
                   lhs.z + rhs.z,
                   lhs.w + rhs.w);
}

/* ------------------------------------------------------------------------- */
/*!
 *  \brief      Vector4の減算
 *  \param[in]  lhs     左辺
 *  \param[in]  rhs     右辺
 *  \return     減算結果
 */
/* ------------------------------------------------------------------------- */
constexpr Vector4 operator-(const Vector4 &lhs, const Vector4 &rhs) noexcept
{
    return Vector4(lhs.x - rhs.x,
                   lhs.y - rhs.y,
                   lhs.z - rhs.z,
                   lhs.w - rhs.w);
}
}    // namespace MGL

#endif    // INCGUARD_MGL_VECTOR4_H_1614659262

// vim: et ts=4 sw=4 sts=4
