// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_math_defs.h
 *  \brief      MGL 数学系ユーティリティ
 *  \date       Since: December 2, 2020. 2:18:15 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_MATH_DEFS_H_1606843095
#define INCGUARD_MGL_MATH_DEFS_H_1606843095

namespace MGL::Math
{
//! ラジアンから度への変換係数
constexpr float kRadianToDegree = 57.29577951308232f;

//! 度からラジアンへの変換係数
constexpr float kDegreeToRadian = 0.017453292519943f;

//! 円周率
constexpr float kPi = 3.141592653589793f;

//! 円周率の半分の値
constexpr float kHalfPi = 1.570796326794897f;

//! 誤差回避のための補正値
constexpr float kEpsilon = 0.000001f;

}    // namespace MGL::Math

#endif    // INCGUARD_MGL_MATH_DEFS_H_1606843095

// vim: et ts=4 sw=4 sts=4
