// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_leaderboard_defs.h
 *  \brief      MGL リーダーボード関連各種定義
 *  \date       Since: September 4, 2021. 1:32:07 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_LEADERBOARD_DEFS_H_1630686727
#define INCGUARD_MGL_LEADERBOARD_DEFS_H_1630686727

#include <cstdint>

#include <mgl/leaderboard/mgl_leaderboard_clipdata.h>
#include <mgl/stl/mgl_stl_containers.h>
#include <mgl/stl/mgl_stl_string.h>

namespace MGL::Leaderboard
{
//! リーダーボード用の識別子
using Identifier = uint32_t;

//! 無効な識別子を表す定数
constexpr Identifier kInvalidIdentifier = 0xFFFFFFFF;

//! オプションデータ配列の型
using OptionDataArray = STL::vector<uint32_t>;

//! ソートタイプ
enum class SortType : uint8_t
{
    Descending,    //!< 降順（大→小）
    Ascending      //!< 昇順（小→大）
};

//! プレイヤーのスコープ
enum class PlayerScope : uint8_t
{
    Global,    //!< 全体
    Friend     //!< フレンドのみ
};

//! エントリデータ
struct EntryData
{
    uint64_t playerID{0};             //!< プレイヤーの識別子
    int32_t rank{0};                  //!< 順位
    STL::string playerName;           //!< プレイヤー名
    int32_t score{0};                 //!< スコア
    STL::vector<uint32_t> options;    //!< オプション情報
    bool hasClip{false};              //!< クリップデータを持っているか
    uint64_t clipID{0};               //!< クリップデータの識別子
};

//! エントリ取得結果
struct FetchResults
{
    bool isSucceeded{false};             //!< 成功フラグ
    STL::vector<EntryData> entryData;    //!< 取得したエントリデータ
    bool isFirst{false};                 //!< エントリデータが先頭のものかのフラグ
    bool isLast{false};                  //!< エントリデータが末尾のものかのフラグ
};

//! エントリ送信結果
struct ReportResults
{
    bool isSucceeded{false};    //!< 送信成功フラグ
};
}    // namespace MGL::Leaderboard

#endif    // INCGUARD_MGL_LEADERBOARD_DEFS_H_1630686727

// vim: et ts=4 sw=4 sts=4
