// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_touch_settings.h
 *  \brief      MGL タッチ入力設定
 *  \date       Since: October 11, 2022. 8:54:28 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_TOUCH_SETTINGS_H_1665446068
#define INCGUARD_MGL_TOUCH_SETTINGS_H_1665446068

#include <mgl/input/touch/mgl_touch_server.h>
#include <mgl/mgl_environment.h>

namespace MGL::Input
{
//! MGL タッチ入力設定
class TouchSettings
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     */
    /* ------------------------------------------------------------------------- */
    TouchSettings() noexcept
        : _server(TouchServer::GetInstance())
    {
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      タッチの入力範囲を設定
     *  \param[in]  bounds      入力範囲
     */
    /* ------------------------------------------------------------------------- */
    void SetBounds(const Rectangle &bounds) noexcept
    {
        _server.SetBounds(bounds);
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      タッチの入力範囲を論理サイズで設定
     *  \param[in]  bounds      入力範囲
     *  \param[in]  logicalSize 論理サイズ
     */
    /* ------------------------------------------------------------------------- */
    void SetBounds(const Rectangle &bounds, const Vector2 &logicalSize) noexcept
    {
        _server.SetBounds(bounds, logicalSize);
    }

private:
    TouchServer &_server;
};
}    // namespace MGL::Input

#endif    // INCGUARD_MGL_TOUCH_SETTINGS_H_1665446068

// vim: et ts=4 sw=4 sts=4
