// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_touch_server.h
 *  \brief      MGL タッチ入力サーバ
 *  \date       Since: February 16, 2021. 3:26:32 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_TOUCH_SERVER_H_1613413592
#define INCGUARD_MGL_TOUCH_SERVER_H_1613413592

#include <mgl/common/mgl_singleton.h>
#include <mgl/event/mgl_event.h>
#include <mgl/input/mgl_input_bounds.h>
#include <mgl/input/touch/mgl_touch_delegate.h>
#include <mgl/stl/mgl_stl_memory.h>

namespace MGL
{
class InitializerDelegate;
};

namespace MGL::Input
{
//! タッチサーバクラス
class TouchServer final : public SharedSingleton<TouchServer>
{
public:
    static STL::unique_ptr<TouchServer> &GetInstanceRef() noexcept;

    TouchServer() noexcept;

    bool Initialize(STL::unique_ptr<TouchDelegate> &delegate) noexcept;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      タッチサーバが有効かどうかを返す
     *  \retval     true    有効
     *  \retval     false   無効
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsAvailable() const noexcept
    {
        return _delegate != nullptr;
    }

    [[nodiscard]] const TouchState &GetState(size_t index) const noexcept;
    [[nodiscard]] const TouchState &GetState(TouchID touchID) const noexcept;
    [[nodiscard]] const TouchState &GetState(const Rectangle &rectangle) const noexcept;

    void SetBounds(const Rectangle &bounds) noexcept;
    void SetBounds(const Rectangle &bounds, const Vector2 &logicalSize) noexcept;

private:
    static void OnEventPreFrameUpdate(void *callbackArg, void *notifyArg) noexcept;
    static void OnEventChangeClientSize(void *callbackArg, void *notifyArg) noexcept;

    void UpdatePosition() noexcept;

    STL::unique_ptr<TouchDelegate> _delegate;
    Event::Handle _eventPreFrameUpdate;
    Event::Handle _eventChangeClientSize;
    TouchStateArray _stateArray;
    TouchState _invalidState;

    InputBounds _bounds;
    Vector2 _clientSize;
};
}    // namespace MGL::Input

#endif    // INCGUARD_MGL_TOUCH_SERVER_H_1613413592

// vim: et ts=4 sw=4 sts=4
