// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_touch_delegate_event.h
 *  \brief      MGL イベントコールバックによるタッチ入力デリゲート
 *  \date       Since: February 16, 2021. 3:42:31 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_TOUCH_DELEGATE_EVENT_H_1613414551
#define INCGUARD_MGL_TOUCH_DELEGATE_EVENT_H_1613414551

#include <mgl/mgl_environment.h>
#if defined(MGL_TOUCH_DELEGATE_ENABLE_EVENT)

#include <type_traits>

#include <mgl/event/mgl_event.h>
#include <mgl/input/touch/mgl_touch_delegate.h>

namespace MGL::Input
{
//! タッチ入力イベントの種類
enum class TouchEventType : uint8_t
{
    None,     //!< なし
    Begin,    //!< タッチ開始
    Move,     //!< タッチしたまま移動
    End,      //!< タッチの終了
};

//! タッチ入力イベントの引数
struct TouchEventArgument
{
    TouchEventType type{TouchEventType::None};    //!< イベントの種類
    Vector2 position;                             //!< タッチ位置
    uint64_t deviceID{0};                         //!< デバイス側の識別番号
};

//! イベントコールバックによるマウス入力デリゲートクラス
class EventTouchDelegate : public TouchDelegate
{
public:
    EventTouchDelegate() noexcept;

    void UpdateState(TouchStateArray &stateArray) noexcept override;

private:
    static void OnEventInputTouch(void *callbackArg, void *notifyArg) noexcept;

    void OnBegin(uint64_t deviceID, const Vector2 &position) noexcept;
    void OnMove(uint64_t deviceID, const Vector2 &position) noexcept;
    void OnEnd(uint64_t deviceID) noexcept;

    Event::Handle _event;
    TouchStateArray _stateArray;

    TouchID _currentTouchID;
};

}    // namespace MGL::Input

#endif    // MGL_TOUCH_DELEGATE_ENABLE_EVENT
#endif    // INCGUARD_MGL_TOUCH_DELEGATE_EVENT_H_1613414551

// vim: et ts=4 sw=4 sts=4
