// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_touch_delegate.h
 *  \brief      MGL タッチ入力デリゲート基底クラス
 *  \date       Since: February 16, 2021. 3:24:52 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_TOUCH_DELEGATE_H_1613413492
#define INCGUARD_MGL_TOUCH_DELEGATE_H_1613413492

#include <mgl/input/touch/mgl_touch_state.h>

namespace MGL::Input
{
//! タッチ入力デリゲート基底クラス
class TouchDelegate
{
public:
    virtual ~TouchDelegate() noexcept = default;
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      タッチ入力状態の更新処理
     *  \param[out] stateArray  更新するステート
     */
    /* ------------------------------------------------------------------------- */
    virtual void UpdateState(TouchStateArray &stateArray) noexcept = 0;
};
}   // namespace MGL::Input

#endif	// INCGUARD_MGL_TOUCH_DELEGATE_H_1613413492

// vim: et ts=4 sw=4 sts=4
