// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_mouse_event.h
 *  \brief      MGL マウスイベント定義
 *  \date       Since: February 22, 2021. 2:06:55 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_MOUSE_EVENT_H_1613927215
#define INCGUARD_MGL_MOUSE_EVENT_H_1613927215

#include <mgl/input/mouse/mgl_mouse_state.h>

namespace MGL::Input
{
//! マウス入力イベントの種類
enum class MouseEventType : uint8_t
{
    None,            //!< なし
    ButtonDown,      //!< ボタンダウン
    ButtonUp,        //!< ボタンアップ
    MovePosition,    //!< カーソルの移動
    DeltaWheel,      //!< ホイール操作
};

//! マウス入力イベントの引数
struct MouseEventArgument
{
    MouseEventType type{MouseEventType::None};    //!< イベントの種類
    MouseButton button{MouseButton::None};        //!< 押された or 離されたボタン
    Vector2 position;                             //!< ポインタの位置
    Vector2 deltaMove;                            //!< 移動量
};

}    // namespace MGL::Input
#endif    // INCGUARD_MGL_MOUSE_EVENT_H_1613927215

// vim: et ts=4 sw=4 sts=4
