// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_mouse_delegate_win32.h
 *  \brief      MGL Win32用マウスデリゲート
 *  \date       Since: March 31, 2021. 10:24:48 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_MOUSE_DELEGATE_WIN32_H_1617153888
#define INCGUARD_MGL_MOUSE_DELEGATE_WIN32_H_1617153888

#include <mgl/mgl_environment.h>
#if defined(MGL_MOUSE_DELEGATE_ENABLE_WIN32)

#include <mgl/input/mouse/mgl_mouse_delegate.h>

namespace MGL::Input
{
//! Win32用マウス入力デリゲートクラス
class Win32MouseDelegate : public MouseDelegate
{
public:
    Win32MouseDelegate() noexcept;

    void UpdateState(MouseState &state) noexcept override;
    void PostUpdatePosition(const MouseState &state) noexcept override;

    bool SetCursorMode(CursorMode cursorMode) noexcept override;
    [[nodiscard]] CursorMode GetCursorMode() const noexcept override;

    void SetCursorVisibleMode(CursorVisibleMode visibleMode) noexcept override;
    [[nodiscard]] CursorVisibleMode GetCursorVisibleMode() const noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      マウスの接続状態を取得
     *  \retval     true    接続されている
     *  \retval     false   接続されていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsConnecting() const noexcept override
    {
        return true;
    }

private:
    void UpdateCursorAutoErase(const MouseState &state, float elapsedTime) noexcept;
    void SetVisibleCursor(bool isVisible) noexcept;
    static void FixCursorPosition() noexcept;

    CursorMode _cursorMode;
    CursorVisibleMode _cursorVisibleMode;
    float _cursorDisplayTime;
    bool _isVisibleCursor;
};

}    // namespace MGL::Input

#endif    // MGL_MOUSE_DELEGATE_ENABLE_WIN32
#endif    // INCGUARD_MGL_MOUSE_DELEGATE_WIN32_H_1617153888

// vim: et ts=4 sw=4 sts=4
