// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_mouse_delegate_apple_gc.h
 *  \brief      GameControllerフレームワークによるマウスデリゲート
 *  \date       Since: July 5, 2022. 7:00:59 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_MOUSE_DELEGATE_APPLE_GC_H_1656972059
#define INCGUARD_MGL_MOUSE_DELEGATE_APPLE_GC_H_1656972059

#include <mgl/mgl_environment.h>

#if defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)


#if defined(__OBJC__)
#include <GameController/GameController.h>
#endif

#include <mgl/input/mouse/mgl_mouse_delegate.h>

namespace MGL::Input
{
//! GameControllerフレームワークによるマウスデリゲート
class AppleGCMouseDelegate : public MouseDelegate
{
public:
    static bool IsAvailable() noexcept;

    AppleGCMouseDelegate() noexcept;
    ~AppleGCMouseDelegate() noexcept;

    void UpdateState(MouseState &state) noexcept override;
    void PostUpdatePosition(const MouseState &state) noexcept override;
    bool SetCursorMode(CursorMode cursorMode) noexcept override;
    [[nodiscard]] CursorMode GetCursorMode() const noexcept override;
    void SetCursorVisibleMode(CursorVisibleMode visibleMode) noexcept override;
    [[nodiscard]] CursorVisibleMode GetCursorVisibleMode() const noexcept override;

    [[nodiscard]] bool IsConnecting() const noexcept override;

private:
    void RegisterNotification() noexcept;

    void OnMove(float deltaX, float deltaY) noexcept;

#if defined(__OBJC__)
    API_AVAILABLE(macos(11.0), ios(14.0), tvos(14.0)) GCMouseInput *_currentInput;
    NSObject *_becomeObserver;
    NSObject *_stopObserver;
#else
    void *_currentInput;
    void *_becomeObserver;
    void *_stopObserver;
#endif

    float _deltaX;
    float _deltaY;
};
}    // namespace MGL::Input

#endif    // defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)
#endif    // INCGUARD_MGL_MOUSE_DELEGATE_APPLE_GC_H_1656972059

// vim: et ts=4 sw=4 sts=4
