// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_mouse_delegate.h
 *  \brief      MGL マウス入力デリゲート基底クラス
 *  \date       Since: December 28, 2020. 17:46:30 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_MOUSE_DELEGATE_H_1609145190
#define INCGUARD_MGL_MOUSE_DELEGATE_H_1609145190

#include <mgl/input/mouse/mgl_mouse_state.h>

namespace MGL::Input
{
//! マウス入力デリゲート基底クラス
class MouseDelegate
{
public:
    virtual ~MouseDelegate() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      マウス入力状態の更新処理
     *  \param[out] state   更新するステート
     */
    /* ------------------------------------------------------------------------- */
    virtual void UpdateState(MouseState &state) noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      マウスの座標確定後の処理
     *  \param[in]  state   更新されたステート
     */
    /* ------------------------------------------------------------------------- */
    virtual void PostUpdatePosition(const MouseState &state) noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      カーソルモードを設定
     *  \param[in]  cursorMode  設定するカーソルモード
     *  \retval     true        成功
     *  \retval     false       失敗
     */
    /* ------------------------------------------------------------------------- */
    virtual bool SetCursorMode(CursorMode cursorMode) noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      カーソルモードを取得
     *  \return     現在のカーソルモード
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual CursorMode GetCursorMode() const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      カーソルの表示モードを設定
     *  \param[in]  visibleMode 設定する表示モード
     */
    /* ------------------------------------------------------------------------- */
    virtual void SetCursorVisibleMode(CursorVisibleMode visibleMode) noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      カーソルの表示モードを取得
     *  \return     現在のカーソルの表示モード
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual CursorVisibleMode GetCursorVisibleMode() const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      マウスの接続状態を取得
     *  \retval     true    接続されている
     *  \retval     false   接続されていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual bool IsConnecting() const noexcept = 0;
};
}    // namespace MGL::Input

#endif    // INCGUARD_MGL_MOUSE_DELEGATE_H_1609145190

// vim: et ts=4 sw=4 sts=4
